/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.util.Util;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiContainer.class}, priority=499)
public class GuiContainerMixin {
    @Unique
    private static final ResourceLocation NPCS$LOCATION = new ResourceLocation("customnpcs", "textures/gui/slot.png");

    @Inject(method={"drawSlot"}, at={@At(value="HEAD")})
    public void npcs$drawSlot(Slot slotIn, CallbackInfo ci) {
        if (!CustomNpcs.ShowRarityItem || slotIn.func_75211_c().func_190926_b()) {
            return;
        }
        float[] color = null;
        float y = 0.0f;
        if (slotIn.func_75211_c().func_77978_p() != null && slotIn.func_75211_c().func_77978_p().func_150297_b("RarityShow", 10)) {
            NBTTagCompound nbt = slotIn.func_75211_c().func_77978_p().func_74775_l("RarityShow");
            if (nbt.func_150297_b("color", 3) || nbt.func_150297_b("color", 4) || nbt.func_150297_b("color", 8)) {
                if (nbt.func_150297_b("color", 4)) {
                    int c = (int)nbt.func_74763_f("color");
                    color = new float[]{(float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f};
                } else {
                    int c = -1;
                    if (nbt.func_150297_b("color", 3)) {
                        c = nbt.func_74762_e("color");
                    } else if (nbt.func_150297_b("color", 4)) {
                        c = (int)nbt.func_74763_f("color");
                    } else {
                        try {
                            c = Integer.getInteger(nbt.func_74779_i("color"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    color = new float[]{(float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, 1.0f};
                }
            } else if (nbt.func_150297_b("rarity", 8)) {
                String rarity = nbt.func_74779_i("rarity");
                EnumRarity found = null;
                for (EnumRarity er : EnumRarity.values()) {
                    if (!er.getName().equalsIgnoreCase(rarity)) continue;
                    found = er;
                    break;
                }
                if (found == null) {
                    for (EnumRarity er : EnumRarity.values()) {
                        if (!er.name().equalsIgnoreCase(rarity)) continue;
                        found = er;
                        break;
                    }
                }
                if (found != null) {
                    color = Util.instance.getColorF(found.getColor().func_175746_b());
                }
            }
            if (nbt.func_150297_b("type", 3)) {
                y = nbt.func_74762_e("type") % 4;
            }
        }
        if (color == null) {
            int index = slotIn.func_75211_c().func_77973_b().getForgeRarity(slotIn.func_75211_c()).getColor().func_175746_b();
            if (index > 14) {
                return;
            }
            color = Util.instance.getColorF(index);
        }
        if (color == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179109_b((float)slotIn.field_75223_e, (float)slotIn.field_75221_f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179131_c((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NPCS$LOCATION);
        this.npcs$drawTexturedModalRect(y);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Unique
    public void npcs$drawTexturedModalRect(float y) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f = 0.00390625f;
        bufferbuilder.func_181662_b(0.0, 32.0, 0.0).func_187315_a(0.734375, (1.0 + (double)y) * 32.0 * (double)f).func_181675_d();
        bufferbuilder.func_181662_b(32.0, 32.0, 0.0).func_187315_a(0.859375, (1.0 + (double)y) * 32.0 * (double)f).func_181675_d();
        bufferbuilder.func_181662_b(32.0, 0.0, 0.0).func_187315_a(0.859375, (double)y * 32.0 * (double)f).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.734375, (double)y * 32.0 * (double)f).func_181675_d();
        tessellator.func_78381_a();
    }
}

